/*
 *  KernelEx
 *  Copyright (C) 2008, Xeno86
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _SHELL32_APILIST_H
#define _SHELL32_APILIST_H

#include <shlobj.h>
#include <shellapi.h>
#include "kexcoresdk.h"

BOOL init_shell32();
BOOL init_shfolder();
void uninit_shell32();
extern const apilib_api_table apitable_shell32;
extern const apilib_api_table apitable_shfolder;

/*** AUTOGENERATED APILIST DECLARATIONS BEGIN ***/

// shell32\SHBindToParent.c
HRESULT WINAPI SHBindToParent_new(LPCITEMIDLIST pidl, REFIID riid, VOID **ppv, LPCITEMIDLIST *ppidlLast);

// shell32\SHCreateDirectoryEx.c
int WINAPI SHCreateDirectoryExA_new(HWND hwnd, LPCSTR pszPathA, SECURITY_ATTRIBUTES *psa);
int WINAPI SHCreateDirectoryExW_new(HWND hwnd, LPCWSTR pszPathW, SECURITY_ATTRIBUTES *psa);

// shell32\SHGetFolderLocation.c
HRESULT WINAPI SHGetFolderLocation_new(HWND hwndOwner, int nFolder, HANDLE hToken, DWORD dwReserved, LPVOID *ppidl);

// shell32\SHGetFolderPath.c
HRESULT WINAPI SHGetFolderPathA_fix(HWND hwndOwner, int nFolder, HANDLE hToken, DWORD dwFlags, LPSTR pszPath);
HRESULT WINAPI SHGetFolderPathW_fix(HWND hwndOwner, int nFolder, HANDLE hToken, DWORD dwFlags, LPWSTR pszPath);
HRESULT SHGetFolderPathAndSubDirA_xp (HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPCSTR pszSubDir, LPSTR pszPath);
HRESULT SHGetFolderPathAndSubDirW_xp (HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPCWSTR pwszSubDir, LPWSTR pwszPath);

// shell32\SHGetSpecialFolder.c
HRESULT WINAPI SHGetSpecialFolderLocation_fix(HWND hwndOwner, int nFolder, LPVOID *_ppidl);
BOOL WINAPI SHGetSpecialFolderPathA_new(HWND hwndOwner, LPSTR lpszPath, int nFolder, BOOL fCreate);
BOOL WINAPI SHGetSpecialFolderPathW_new(HWND hwndOwner, LPWSTR lpszPathW, int nFolder, BOOL fCreate);

// shell32\SHParseDisplayName.c
HRESULT WINAPI SHParseDisplayName_new(PCWSTR pszName, IBindCtx *pbc, LPITEMIDLIST *ppidl, SFGAOF sfgaoIn, SFGAOF *psfgaoOut);

// shell32\_shell32_apilist.c

// shell32\shellpath.c

// shell32\unishell32.c
FWDPROC ExtractIconExW_fwd;
FWDPROC ExtractIconW_fwd;
FWDPROC FindExecutableW_fwd;
FWDPROC SHBrowseForFolderW_fwd;
FWDPROC Shell_NotifyIconW_fwd;
FWDPROC ShellAboutW_fwd;
FWDPROC ShellExecuteExW_fwd;
FWDPROC ShellExecuteW_fwd;
FWDPROC SHFileOperationW_fwd;
FWDPROC SHGetFileInfoW_fwd;
FWDPROC SHGetNewLinkInfoW_fwd;
FWDPROC StrChrA_fwd;
FWDPROC StrChrW_fwd;
FWDPROC StrRStrIA_fwd;
UINT WINAPI DragQueryFileW_new(HDROP hDrop, UINT iFile, LPWSTR lpszFileW, UINT cch);

#define shell32_ordinal_apis NULL
/*** AUTOGENERATED APILIST DECLARATIONS END ***/

#endif
